using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace DrumPad
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat Gry
        SoundEffect kick;
        SoundEffect cymbolTing;
        SoundEffect snare;
        SoundEffect top;

        // Biecy stan gamepada podczas metody Update()
        GamePadState pad1;

        // Poprzedni stan gamepada. XNA inicjalizuje do stanu aden  
        // przycisk nie wcinity. Po pierwszym wywoaniu metody Update()
        // bdzie tu przechowywany poprzedni stan gamepada
        GamePadState oldpad1;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Dodaj w tym miejscu swoj logik inicjalizacji

            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            kick = Content.Load<SoundEffect>("kick");
            cymbolTing = Content.Load<SoundEffect>("cymbolTing");
            snare = Content.Load<SoundEffect>("snare");
            top = Content.Load<SoundEffect>("top");
        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala na wyjcie z gry
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            pad1 = GamePad.GetState(PlayerIndex.One);

            if (pad1.IsConnected)
            {
                // pozwala na wyjcie, gdy zostanie wciniety przycisk back
                if (pad1.Buttons.Back == ButtonState.Pressed)
                {
                    this.Exit();
                }

                // sprawd, czy przycisk A zosta wcinity od ostatniego wywoania metody Update()
                if (oldpad1.Buttons.A == ButtonState.Released &&
                     pad1.Buttons.A == ButtonState.Pressed)
                {
                    cymbolTing.Play();
                }

                // sprawd, czy przycisk B zosta wcinity od ostatniego wywoania metody Update()
                if (oldpad1.Buttons.B == ButtonState.Released &&
                     pad1.Buttons.B == ButtonState.Pressed)
                {
                    kick.Play();
                }

                // sprawd, czy przycisk X zosta wcinity od ostatniego wywoania metody Update()
                if (oldpad1.Buttons.X == ButtonState.Released &&
                     pad1.Buttons.X == ButtonState.Pressed)
                {
                    snare.Play();
                }

                // sprawd, czy przycisk Y zosta wcinity od ostatniego wywoania metody Update()
                if (oldpad1.Buttons.Y == ButtonState.Released &&
                     pad1.Buttons.Y == ButtonState.Pressed)
                {
                    top.Play();
                }
            }

            // zapisz biecy stan gamepada dla nastepnego
            // wywoania metody Update()
            oldpad1 = pad1;


            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Dodaj w tym miejscu kod wyswietlajcy

            base.Draw(gameTime);
        }
    }
}
